#!/usr/bin/perl

###############################################################################
#                                                                             #
#               Dimke's Kontaktformular Version 1.0                           #
#                                                                             #
#               All rights reserved. Copyright (C) 2004                       #
#               Dipl.-Ing. Markus Robert Keler                               #
#               Bad Schussenried, Germany                                     #
#                                                                             #
#               For latest updates see http://developer.dipl-ing-kessler.de   #
#                                                                             #
###############################################################################
#                                                                             #
#               Einsatz:                                                      #
#                                                                             #
#               Verarbeiten von Benutzereingaben aus einem HTML-Formular      #
#               zum Zwecke des Versandes als Email per Unix-Sendmail-Aufruf.  #
#               Die Email-Adressen des Empfngers sind hierbei dem Absender   #
#               zum Schutze vor Spam nicht offen sichtbar.                    #
#                                                                             #
###############################################################################


### Set your variables here and don't modify other parts of this script #######

$background     = 'http://www.dipl-ing-kessler.de/m0oq86lc.jpg';
$mailprog       = '/usr/sbin/sendmail';

%Ziel_Hash = (
   "-Leer-"              ,  "- Bitte Auswahl treffen -",
   "Kessler Arbeit"      ,  "markus.kessler\@traumjob.de",
   "Kessler Privat"      ,  "geht_niemanden_was_an\@dipl-ing-kessler.de"
);

##############################################################################

# Get the input
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

# Split the name-value pairs
@pairs = split(/&/, $buffer);

foreach $pair (@pairs) {
   ($name, $value) = split(/=/, $pair);

   # Un-Webify plus signs and %-encoding
   $value =~ tr/+/ /;
   $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
   $value =~ s/<!--(.|\n)*-->//g;

   $FORM{$name} = $value;
}

$Empfaenger_Name = $FORM{'Ziel_Name'};
$Empfaenger_Mail = $Ziel_Hash{$Empfaenger_Name};

# Check all input
if ($FORM{'Ziel_Name'} eq '- Bitte Auswahl treffen -' or $FORM{'Kunde_Name'} eq '' or $FORM{'Kunde_mail'} eq '' or
    $FORM{'Betreff'} eq '' or $FORM{'Nachricht'} eq ''){
   print "Content-Type: text/html\n\n";
   print "<html><head><title>Fehler: Formular unvollst&auml;ndig</title></head>";
   print "<body background=$background>";
   print "<h2>Fehler: Formular nicht vollst&auml;ndig ausgef&uuml;llt.<br>";
   print "Bitte klicken Sie auf \"Zur&uuml;ck\".<p>";
   print "</body></html>\n";
}

elsif ( ($FORM{'Kunde_mail'} =~ tr/@//) != 1 or ($FORM{'Kunde_mail'} =~ tr/.//) < 1 ){
   print "Content-Type: text/html\n\n";
   print "<html><head><title>Fehler: Mail-Adresse fehlerhaft</title></head>";
   print "<body background=$background>";
   print "<h2>Fehler: Mail-Adresse fehlerhaft.<br>";
   print "Bitte klicken Sie auf \"Zur&uuml;ck\".<p>";
   print "</body></html>\n";
}

else {

   # Print to File "Mail"

   open (MAIL, "|$mailprog -t") || die "Can't open $mailprog!\n";

   print MAIL "From: $FORM{'Kunde_Name'} <$FORM{'Kunde_mail'}>\n";
   print MAIL "Reply-to: $FORM{'Kunde_Name'} <$FORM{'Kunde_mail'}>\n";
   if ($FORM{'Kopie_an_Kunde'} eq 'Ja'){
      print MAIL "To: $FORM{'Kunde_Name'} <$FORM{'Kunde_mail'}>\n";
      print MAIL "Bcc: $Empfaenger_Mail\n";
   }
   else {
      print MAIL "To: $Empfaenger_Mail\n";
   }
   print MAIL "X-Mailer: Dimke\'s Kontaktformular v1.0, (C) 2004, Dipl.-Ing. Markus Robert Kessler\n";
   print MAIL "Subject: $FORM{'Betreff'}\n\n";
   print MAIL "$FORM{'Nachricht'}\n";

   close (MAIL);

   # Print Confirmation of delivery

   print "Content-Type: text/html\n\n";
   print "<html><head><title>Ihre Nachricht wurde abgesandt</title></head>";
   print "<body background=$background>";
   print "<h2>Ihre Nachricht wurde soeben an $Empfaenger_Name abgesandt.<p>";
   print "Wir melden uns so schnell wie m&ouml;glich.</h2>";
   print "</body></html>\n";
}

exit;

