#!/usr/bin/perl

###############################################################################
#                                                                             #
#               Dimkes Geburtstagsgrusskarten-Generator Version 1.1           #
#                                                                             #
#               Alle Rechte vorbehalten. Copyright (C) 2004 - 2007            #
#               Dipl.-Ing. Markus Robert Kessler                              #
#               Bad Schussenried, Deutschland                                 #
#                                                                             #
#               Weiterentwicklungen etc.:http://developer.dipl-ing-kessler.de #
#                                                                             #
###############################################################################
#                                                                             #
#               Funktion: Automatisierter Versand von Grusskarten mittels     #
#               ueber die Unix-Crontab aufgerufenem Perl-Skript               #
#                                                                             #
###############################################################################

require "/voller/pfad/zu/grusskrt.cfg";

$mailprog       = '/usr/sbin/sendmail';

###############################################################################

($sek,$min,$stunde,$tag,$mon_0,$jahr_1900,$wday,$yday,$isdst) = localtime(time);
$jahr  = $jahr_1900 + 1900;
$monat = $mon_0 + 1;

open(AdressenDatei,$adressen) or
   eintrag_logdatei("Fehler", "Zugriff auf Adressendatei fehlgeschlagen.");

@eintraege=<AdressenDatei>;
close(AdressenDatei);

foreach $i (@eintraege) {

   @eintrag = split(/$feld_trenner/,$i);
   @geb_datum = split(/$datum_trenner/,$eintrag[0]);

   if ( (($geb_datum[0] - $tag) eq "0") and (($geb_datum[1] - $monat) eq "0")) {
      ### Tag und Monat gleich? ==> Geburtstag.                             ###

      ### Subtraktion statt eq oder ne erzwingt arithmetische Auswertung.   ###
      ### Damit Eingabe tolerant, "01.01." gleich wie "1.1.".               ###

      $leb_alter = $jahr - $geb_datum[2];

      smtp("\"$eintrag[1]\"\<$eintrag[2]\>", $leb_alter, $eintrag[3]);
   }
}


sub smtp {
   my ($empfaenger, $alter, $anrede) = @_;
   my $html_seite1_lokal = $html_seite1;
   my $html_seite2_lokal = $html_seite2;

   chomp($anrede);   ### Anrede ist letztes Feld ==> CR mit chomp entfernen ###
   $html_seite2_lokal =~ s/\[anrede\]/$anrede/;

   if($alter > 0) {
      $alter .= ". ";
   }
   else {
      $alter = " ";
   }
   $html_seite2_lokal =~ s/\[alter\]/$alter/;



   open (MAIL, "|$mailprog -t") or
      eintrag_logdatei("Fehler", "Zugriff auf SendMail fehlgeschlagen.");

   print MAIL "From: $absender\n";
   print MAIL "Reply-to: $absender\n";
   print MAIL "To: $empfaenger\n";
   if ($permanent_bcc ne '') {
      print MAIL "Bcc: $permanent_bcc\n";
   }
   print MAIL "X-Mailer: $x_mailer\n";
   print MAIL "X-Complaints-To: $x_complaints\n";
   print MAIL "Subject: $betreff\n";
   print MAIL "MIME-Version: 1.0\n";
   print MAIL "Content-Type: multipart/alternative\; boundary=boundary42\n\n";

   ## Text only ###############################################################

   print MAIL "--boundary42\n";
   print MAIL "Content-Type: text/plain; charset=\"iso-8859-1\"\n\n";

   print MAIL "Dies ist eine HTML-Nachricht.\n\n";
   print MAIL "Bitte HTML aktivieren!\n";

   ## HTML mail ###############################################################

   print MAIL "--boundary42\n";
   print MAIL "Content-Type: text/html; charset=\"iso-8859-1\"\n\n";

   print MAIL "$html_kopf\n";

   if ($s1_s2_parallel eq 'ja') {
      print MAIL "<table border=0>\n<tr>\n",
                 "<td align=center valign=absmiddle>$html_seite1_lokal</td>\n",
                 "<td></td>\n",
                 "<td align=center valign=absmiddle>$html_seite2_lokal</td>\n",
                 "</tr>\n</table>\n";
   }
   else {
      print MAIL "$html_seite1_lokal\n";
      print MAIL "$html_seite2_lokal\n";
   }

   print MAIL "$html_schluss\n";

   close (MAIL);
 
   # Eintrag in Logdatei

   eintrag_logdatei("Erfolg", "Mail an $empfaenger.");
}


sub eintrag_logdatei {
   my($status, $grund)= @_;
   ( $sek, $min, $stunde, $tag, $mon_0, $jahr_1900, $wday, $yday, $isdst ) = localtime(time);
   $jahr  = $jahr_1900 + 1900;
   $monat = $mon_0 + 1;
   my $zeitstempel =
      sprintf ("%02d.%02d.%4d %02d:%02d:%02d", $tag, $monat, $jahr, $stunde, $min, $sek);

   open(LogDatei,">>$logdatei") or die "Zugriff auf Logdatei fehlgeschlagen. Status: $!\n";
   print LogDatei "$zeitstempel Status: $status - $grund\n";

   close(LogDatei);
   if ($status eq "Fehler") {
      exit;
   }
}

exit;

